#ifndef MONOALG3D_MODEL_TORORD_FKATP_ENDO_H
#define MONOALG3D_MODEL_TORORD_FKATP_ENDO_H


#define NEQ 43
#define INITIAL_V (-88.763800f)

#include "../model_common.h"
#include "../../extra_data_library/helper_functions.h"

#ifdef __CUDACC__

#include "../../gpu_utils/gpu_utils.h"

__global__ void kernel_set_model_initial_conditions(real *sv, int num_volumes, real *ischFactor, real *HCMRE, int *CELLT, real *APEXB, real *ctrlnormendo, real *ctrlischendo, real *hcmnormendo, real *hcmischendo, real *ctrlnormepi, real *ctrlischepi, real *hcmnormepi, real *hcmischepi);

__global__ void solve_gpu(real cur_time, real dt, real *sv, real* stim_currents,
                          uint32_t *cells_to_solve, uint32_t num_cells_to_solve,
                          int num_steps, real *ischFactor, real *extra_parameters, real *HCMRE, int *CELLT, real *APEXB);

inline __device__ void RHS_gpu(real *sv, real *rDY, real stim_current, int thread_id, real dt, real ischFactor, real *extra_parameters, real HCMRE, int CELLT, real APEXB);
inline __device__ void solve_forward_euler_gpu_adpt(real *sv, real stim_curr, real final_time, int thread_id, real ischFactor, real *extra_parameters, real HCMRE, int CELLT, real APEXB);

#endif

void RHS_cpu(const real *sv, real *rDY_, real stim_current, real dt, real ischFactor, real *extra_parameters,real HCMRE, int CELLT, real APEXB);
inline void solve_forward_euler_cpu_adpt(real *sv, real stim_curr, real final_time, int thread_id, real ischFactor, real *extra_parameters, real HCMRE, int CELLT, real APEXB);

void solve_model_ode_cpu(real dt, real *sv, real stim_current, real ischFactor, real *extra_parameters, real HCMRE, int CELLT, real APEXB);
#endif //MONOALG3D_MODEL_TORORD_FKATP_ENDO_H

